<?php

namespace App\Pages\Himsapi;

use Livewire\Component;
use Illuminate\Support\Str;
use Livewire\Attributes\On;
use App\Traits\WithSweetAlert;
use App\Models\CollectionParameter;

class CollectionParameterList extends Component
{
    use WithSweetAlert;

    public $collection_id;
    public $collection_parameter_id;

    public $label;
    public $placeholder;
    public $name;
    public $type;
    public $is_required;
    public $default_value;
    public $options;
    public $status;

    public function updatedLabel($value)
    {
        if($value && $this->name == '') {
            $this->name = Str::slug($value, '_');
        }
    }


    #[On('addParameterModal')]
    public function addParameterModal($data = [])
    {
        $this->reset(
            [
                'collection_parameter_id',
                'label',
                'placeholder',
                'name',
                'type',
                'is_required',
                'default_value',
                'options',
                'status',
            ]
        );

        $this->dispatch('typeahead_reset');

        if (isset($data['id'])) {
            $this->parameterEdit($data['id']);
        }
        $this->dispatch('modalOpen', 'addParameterModal');
    }

    public function collectionParameterStore()
    {
        $validation = [
            'collection_id' => ['required'],
            'label' => ['required', 'string'],
            'placeholder' => ['nullable', 'string'],
            'name' => ['required', 'string'],
            'type' => ['required', 'integer'],
            'is_required' => ['nullable'],
            'default_value' => ['nullable'],
            'status' => ['required', 'integer'],
        ];

        $this->validate($validation);

        $CollectionParameter = CollectionParameter::findOrNew($this->collection_parameter_id);
        $CollectionParameter->collection_id = $this->collection_id;
        $CollectionParameter->label = $this->label;
        $CollectionParameter->placeholder = $this->placeholder;
        $CollectionParameter->name = $this->name;
        $CollectionParameter->type = $this->type;
        $CollectionParameter->is_required = $this->is_required;
        $CollectionParameter->default_value = $this->default_value;
        $CollectionParameter->options = $this->options;
        $CollectionParameter->status = $this->status;
        $CollectionParameter->save();

        $this->dispatch('refreshDatatable');
        $this->dispatch('modalClose', 'addClientModal');
        $this->alert('success', 'Collection parameter successfully '.($this->collection_parameter_id ? 'updated':'created'));
    }
    public function parameterEdit($id)
    {
        $CollectionParameter = CollectionParameter::find($id);

        if (!$CollectionParameter) {
            $this->alert('error', "CollectionParameter Not Find");
            return;
        }
        $this->collection_parameter_id = $CollectionParameter->id;
        $this->collection_id= $CollectionParameter->collection_id;
        $this->label= $CollectionParameter->label;
        $this->placeholder= $CollectionParameter->placeholder;
        $this->name= $CollectionParameter->name;
        $this->type= $CollectionParameter->type;
        $this->is_required= $CollectionParameter->is_required ? true : false;
        $this->default_value= $CollectionParameter->default_value;
        $this->options= $CollectionParameter->options;
        $this->status= $CollectionParameter->status;

    }
    #[On('parameterDelete')]
    public function parameterDelete($data = [])
    {
        // $data = $this->alertConfirm($data);

        if (isset($data['id'])) {
            $CollectionParameter = CollectionParameter::find($data['id']);

            if (!$CollectionParameter) {
                $this->alert('error','collection parameter not found');
                return;
            }
            $CollectionParameter->ClientCollectionParameters()->delete();
            $CollectionParameter->delete();

            $this->dispatch('refreshDatatable');
            $this->alert('success','collection parameter deleted succesfully');
        }
    }
    public function mount($id)
    {
        $this->collection_id = $id;
    }
    public function render()
    {
        return view('pages.himsapi.collection-parameter-list');
    }
}
