<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\Client;
use App\Models\Collection;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;

use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class CollectionListTable extends DataTableComponent
{
    use WithSweetAlert;

    // protected $model = Collection::class;
    protected $index = 0;
    public function builder(): Builder
    {
        return Collection::query(); // Select some things
    }


    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);

        $this->setTdAttributes(function (Column $column, $row, $columnIndex, $rowIndex) {
            if ($column->isField('request_url')) {
                return [
                'style' => 'font-size:13px;',
                ];
            }

            return [
                'style' => 'font-size:15px;',
            ];
        });
    }

    public function filters(): array
    {

        return [

            DateRangeFilter::make('Verified Period'),
            NumberFilter::make('Amount')

                ->config([
                    'min' => 0,
                    'max' => 10,
                ])

                ->filter(function (Builder $builder, string $value) {

                    $builder->where('id', '<', $value);
                }),
            NumberRangeFilter::make('Success Rate')

                ->options(
                    [
                        'min' => 0,
                        'max' => 100,
                    ]
                )

                ->config([
                    'minRange' => 0,
                    'maxRange' => 100,
                    'suffix' => 'TK',
                ])

                ->filter(function (Builder $builder, array $values) {
                    $builder->where('id', '>=', intval($values['min']))
                        ->where('id', '<=', intval($values['max']));
                }),

        ];
    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("Title", "title")->sortable()->searchable(),
            Column::make("Description", "des")->sortable()->searchable()->deselected(),
            Column::make("Request Url", "request_url")->format(
                fn ($value, $row, Column $column) => $value ? url($value) : ''
            )->sortable()->searchable(),
            Column::make("Response Type", "response_type")
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_collections_response_type','value' => $value])
            )->sortable()->searchable(),
            Column::make("Request Type", "request_type")
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_collections_request_type','value' => $value])
            )->sortable()->searchable(),
            Column::make("Request Limit", "request_limit")->searchable()->sortable()->deselected(),
            Column::make("Is FTP", "is_ftp")->format(
                fn ($value, $row, Column $column) => $value ? 'Yes' : 'No'
            )->sortable()->searchable(),
            Column::make('Status', 'status')
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'common','value' => $value])
            )->searchable()->sortable(),
            ButtonGroupColumn::make("Actions")
                ->buttons([
                    LinkColumn::make('Edit')
                        ->title(fn ($row) => 'Edit')
                        ->location(fn ($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'addApiModal',
                                'class' => 'badge bg-success me-1 p-2 ',
                                'icon' => 'fa fa-edit',
                                'title' => 'Edit',

                            ];
                        }),
                    LinkColumn::make(' Delete')
                        ->title(fn ($row) => 'Delete')
                        ->location(fn ($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'apiDelete',
                                'class' => 'badge bg-danger me-1 p-2 ',
                                'icon' => 'fa fa-trash',
                                'title' => 'Delete',

                            ];
                        }),
                    LinkColumn::make(' ParamValue')
                        ->title(fn ($row) => 'ParamValue')
                        ->location(fn ($row) => route('backend.collection_parameter', ['id' => $row->id]))
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,

                                'class' => 'badge bg-warning me-1 p-2 ',
                                'icon' => 'fa fa-edit',
                                'title' => 'ParamValue',

                            ];
                        }),

                ]),


        ];
    }
}
