<?php

namespace App\Providers;

use Livewire\Livewire;
use Laravel\Sanctum\Sanctum;
use App\Models\PersonalAccessToken;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Resources\Json\JsonResource;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        JsonResource::withoutWrapping();
        Sanctum::usePersonalAccessTokenModel(PersonalAccessToken::class);

        // Livewire::setUpdateRoute(function ($handle) {
        //     return Route::post(env('LIVEWIRE_UPDATE_URL', 'livewire/update'), $handle);
        // });

    }
}
