<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_collections', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('des')->nullable();
            $table->string('request_url')->nullable();
            $table->tinyInteger('response_type')->nullable()->comment('1 = json response,2 = csv response');
            $table->tinyInteger('request_type')->nullable()->comment('1 = get request,2 = post request,3 = both');
            $table->integer('request_limit')->nullable()->comment('per minute');
            $table->tinyInteger('is_ftp')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_collections');
    }
};
