<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_client_collections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->nullable();
            $table->foreignId('collection_id')->nullable();
            $table->string('ftp_host')->nullable();
            $table->string('ftp_port')->nullable();
            $table->string('ftp_user')->nullable();
            $table->string('ftp_pass')->nullable();
            $table->string('ftp_dir')->nullable();
            $table->string('access_stations')->nullable();
            $table->timestamp('last_ftp_success_check')->nullable();
            $table->timestamp('last_ftp_fail_check')->nullable();
            $table->tinyInteger('ftp_status')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_client_collections');
    }
};
