<div>
    <x-slot name="header"> API Setup</x-slot>
    <x-layouts.backend.container>

        <x-layouts.backend.card>
            <x-slot name="card_title">
                <h6>Client Information</h6>
            </x-slot>
            <x-slot name="card_header">
                <button class="btn btn-info me-2">
                    <a href="{{ route('backend.client_list') }}" wire:navigate class="text-white">
                        <span class="fa fa-reply"></span>
                        <b>Back to Client List</b>
                    </a>
                </button>
            </x-slot>
            <div class="row">
                <div class="col-lg-6 me-5" style="border-right: 1px solid black;">
                    <table class="table-sm table table-striped ">
                        <tr style="background-color: #eff6ff;">
                            <th colspan="2" class="text-center"><h4>Client Profile</h4></th>


                        </tr>
                        <tr>
                            <td><b>Name:</b> {{ $Client->name }}</td>
                            <td><b>Address:</b> {{ $Client->address }}</td>

                        </tr>
                        <tr>
                            <td><b>UUID:</b> {{ $Client->uuid }}</td>
                            <td><b>Office Name:</b> {{ $Client->office_name }}</td>

                        </tr>
                        <tr>
                            <td><b>Email:</b> {{ $Client->email }}</td>
                            <td><b>Phone:</b> {{ $Client->phone }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-lg-5 ms-5">

                    <div class="row">
                        <div class="col-lg-6">
                          <b>Expire Date</b>  <x-input.date wire:model.live="expire_at"
                                style="margin: 0" />
                        </div>
                        <div class="col-lg-8 mt-2">
                          <b>Token</b>  <x-input.text-copy wire:model="token"  />
                        </div>
                        <div class="col-lg-4 mt-2">
                            <x-button.warning wire:click="generateToken" wire:target='generateToken' class="btn-sm mt-5"
                                icon="fa fa-check">Regenerate Token
                            </x-button.warning>
                        </div>

                    </div>
                </div>
            </div>

        </x-layouts.backend.card>

        <x-layouts.backend.card>
            <x-slot name="card_title">
                <h6>API Collection</h6>
            </x-slot>
            <livewire:himsapi.datatable.api-setup-table :client_id="$client_id" />
        </x-layouts.backend.card>
    </x-layouts.backend.container>

    <x-modal id="configModal" size="lg" title="{{ $id ? 'Update' : 'Add' }}  Client Information ">

        <div class="row">
            @foreach ($collection_parameters as $key => $item)
            <div class="col-lg-4">
                @if ($item->type == 1)
                    <x-input.text wire:model="parameter_value.{{ $item->id }}" :label="$item->label" :placeholder="$item->placeholder" />
                @elseif($item->type == 2)
                    <x-input.select wire:model="parameter_value.{{ $item->id }}" :label="$item->label" :placeholder="$item->placeholder" :options="explode(',',$item->options)" />
                @elseif($item->type == 3)
                    <x-input.checkbox wire:model="parameter_value.{{ $item->id }}" :label="$item->label" :placeholder="$item->placeholder" />
                @elseif($item->type == 4)
                    <x-input.textarea wire:model="parameter_value.{{ $item->id }}" :label="$item->label" :placeholder="$item->placeholder" />
                @elseif($item->type == 5)
                    <x-input.date wire:model="parameter_value.{{ $item->id }}" :label="$item->label" :placeholder="$item->placeholder" />
                @endif
            </div>
            @endforeach
        </div>
        <div class="row {{ $is_ftp ? '' : 'd-none' }}">
            <div class="col-lg-12">
                <x-input.text wire:model="ftp_host" label="FTP Host" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="ftp_user" label="FTP Username" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="ftp_pass" label="FTP Password" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="ftp_port" label="FTP port" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="ftp_dir" label="Path" require="true" />
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <x-input.checkbox wire:model.live="is_all_station" label="Access All Station"/>
            </div>
            <div class="col-lg-6 {{$is_all_station ? 'd-none' : ''}}">
                <x-button.warning x-data @click="$dispatch('callEventFunc',{callName:'accessStationModal'})" class="btn" icon="fa fa-list">
                        Select Stations
                </x-button.warning>
            </div>
        </div>
        <x-slot name="footer">
            <x-button.success wire:click="clientParameterStore" wire:target='clientParameterStore' class="btn-sm" icon="fa fa-check">
                Save
            </x-button.success>
        </x-slot>
    </x-modal>

    <x-modal id="accessStationModal" size="xl" title="Selected Station List">
        @if ($client_collection_id)
            <div class="row">
                <livewire:himsapi.datatable.station-table :$client_collection_id/>
            </div>
        @endif
    </x-modal>
</div>
