<div>
    <x-slot name="header"> Client List</x-slot>
    <x-layouts.backend.container>

        <x-layouts.backend.card>
            <x-slot name="card_header">

                <x-button.success x-data @click="$dispatch('callEventFunc',{callName:'addClientModal'})" class="btn"
                    icon="fa fa-plus"> Add Client
                </x-button.success>

            </x-slot>
            <livewire:himsapi.datatable.client-table />
        </x-layouts.backend.card>
    </x-layouts.backend.container>

    <x-modal id="addClientModal" size="lg" title="{{ $id ? 'Update' : 'Add' }}  Client Information ">

        <div class="row">
            <div class="col-lg-6">
                <x-input.text wire:model.defer="uuid" label="UUID" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="name" label="Name" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="office_name" label="Office name" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="address" label="address" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="phone" label="phone" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="email" label="email" require="true" />
            </div>
        </div>
        <x-slot name="footer">
            <x-button.success wire:click="clientInfoStore" wire:target='clientInfoStore' class="btn-sm"
                icon="fa fa-check">
                Save
            </x-button.success>
        </x-slot>
    </x-modal>

    <x-modal id="clientViewModal" size="lg" title="Client Informations ">

        <div class="row">
            <div class="col-lg-6">
                <x-input.text wire:model.defer="uuid" label="UUID" disabled />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="name" label="Name" require="true" disabled />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="office_name" label="Office name" require="true" disabled />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="address" label="address" disabled />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="phone" label="phone" require="true" disabled />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model.defer="email" label="email" require="true" disabled />
            </div>

        </div>
        <div class="col-lg-12" style="padding-inline: 0rem;">
            <x-button.warning wire:click="generateToken" wire:target='generateToken' class="btn-sm"
                icon="fa fa-check">Generate API Token
            </x-button.warning>


            <div class="row {{ $token ? '' : 'd-none' }}">
                <div class="col-lg-8 mt-2">
                    <x-input.text-copy wire:model.defer="token" label="Token" require="true" />
                </div>
                <div class="col-lg-4">
                    <x-input.date wire:model.live="expire_at" label="Expire At" require="true" />
                </div>
            </div>

        </div>
        {{-- <x-slot name="footer">
           <x-button.success wire:click="clientInfoStore" wire:target='clientInfoStore' class="btn-sm"
               icon="fa fa-check">
               Save
           </x-button.success>
       </x-slot> --}}
    </x-modal>
</div>
