<?php

use App\Models\CollectionParameter;
use App\Pages\Login;
use App\Pages\Backend\Dashboard;
use App\Pages\Himsapi\ApiSetup;
use App\Pages\Himsapi\ApiDocument;
use App\Pages\Himsapi\ApiInformation;
use App\Pages\Himsapi\ApiLog;
use App\Pages\Himsapi\Client;
use App\Pages\Himsapi\CollectionList;
use App\Pages\Himsapi\CollectionParameterList;
use App\Pages\Himsapi\StationList;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::permanentRedirect('/', 'login');
Route::get('login', Login::class)->name('login')->middleware('guest');

Route::group(['prefix' => 'member', 'as' => 'backend.','middleware' => ['auth']], function () {
    Route::permanentRedirect('/', 'dashboard');
    Route::get('dashboard', Dashboard::class)->name('dashboard');
    Route::get('profile', Dashboard::class)->name('profile');
    Route::get('client-list', Client::class)->name('client_list');
    Route::get('api-log', ApiLog::class)->name('api_log');
    Route::get('api-document', ApiDocument::class)->name('api_document');
    Route::get('api-information', ApiInformation::class)->name('api_information');
    Route::get('api-setup/{id}', ApiSetup::class)->name('api_setup');
    Route::get('api-collection-list', CollectionList::class)->name('api_collection');
    Route::get('collection-parameter/{id}', CollectionParameterList::class)->name('collection_parameter');
    Route::get('station-list', StationList::class)->name('station_list');

    Route::get('datatable/{table}', [BackendDatatableController::class, 'index'])->name('datatable');
});

// Route::view('/', 'welcome');

// Route::view('dashboard', 'dashboard')
//     ->middleware(['auth', 'verified'])
//     ->name('dashboard');*
//     ->middleware(['auth'])
//     ->name('profile');

// require __DIR__.'/auth.php';
